/*
 * Decompiled with CFR 0.152.
 */
package com.simibubi.create.foundation.utility;

import com.simibubi.create.foundation.config.AllConfigs;
import com.simibubi.create.foundation.networking.AllPackets;
import com.simibubi.create.foundation.networking.SimplePacketBase;
import com.simibubi.create.foundation.utility.animation.LerpedFloat;
import java.util.function.Supplier;
import net.minecraft.client.Minecraft;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.network.NetworkEvent;
import net.minecraftforge.network.PacketDistributor;

public class ServerSpeedProvider {
    static int clientTimer = 0;
    static int serverTimer = 0;
    static boolean initialized = false;
    static LerpedFloat modifier = LerpedFloat.linear();

    public static void serverTick() {
        if (++serverTimer > ServerSpeedProvider.getSyncInterval()) {
            AllPackets.channel.send(PacketDistributor.ALL.noArg(), (Object)new Packet());
            serverTimer = 0;
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static void clientTick() {
        if (Minecraft.m_91087_().m_91091_() && Minecraft.m_91087_().m_91104_()) {
            return;
        }
        modifier.tickChaser();
        ++clientTimer;
    }

    public static Integer getSyncInterval() {
        return (Integer)AllConfigs.SERVER.tickrateSyncTimer.get();
    }

    public static float get() {
        return modifier.getValue();
    }

    public static class Packet
    extends SimplePacketBase {
        public Packet() {
        }

        public Packet(FriendlyByteBuf buffer) {
        }

        @Override
        public void write(FriendlyByteBuf buffer) {
        }

        @Override
        public void handle(Supplier<NetworkEvent.Context> context) {
            context.get().enqueueWork(() -> {
                if (!initialized) {
                    initialized = true;
                    clientTimer = 0;
                    return;
                }
                float target = (float)ServerSpeedProvider.getSyncInterval().intValue() / (float)Math.max(clientTimer, 1);
                modifier.chase(Math.min(target, 1.0f), 0.25, LerpedFloat.Chaser.EXP);
                clientTimer = -1;
            });
            context.get().setPacketHandled(true);
        }
    }
}

